/**
 * 
 * pttdial
 *
 * Copyright 2002 Paul T.Threshold
 *
 * getopt function
 * 
 * This software is the proprietary information of Tresoldi Paolo.
 * Thou art not alloweth to remove the Copyright notice.
 *
 */
/**
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */


void opt_not_found(char optchr)
{
	cout << "Unknown or Invalid parameter '-" << optchr << "'!!" << std::endl <<
		"('pttdial -h' for help...)" << std::endl <<
		std::endl;
	exit(1);
}

void opt_missing(char optchr)
{
	cout << "Argument expected for option '-" << optchr << "'!!" << std::endl <<
		"('pttdial -h' for help...)" << std::endl <<
		std::endl;
	exit(1);
}

// mingw getopts seems not to work, so I've written down a new one!
std::string optargs = "";
std::string optarg = "";
std::string::iterator it;
char getopt(std::string args, std::string options)
{
	if (optarg == "") { 
		optargs = args;
		it = optargs.begin();
	}
	for (optarg = ""; it != optargs.end(); ++it) {
		if (*it == '-') {
			++it;
			if (options.find(*it) != -1) {
				char optchr = *it;
				// read a parm only if expected (':')
				if (options.substr(options.find(*it)+1, 1) == ":") {
					++it;
					//if (it == optargs.end())
					//	opt_missing(optchr);
					while (*it == ' ')
						++it;
					if (it == optargs.end() || *it == '-')
						opt_missing(optchr);
					while (*it != ' ' && it != optargs.end()) {
						optarg += *it;
						++it;
					}
				}
				while (*it != ' ' && it != optargs.end()) {
					optarg += *it;
					++it;
				}
				return optchr;
			} else
				opt_not_found(*it);
		}
	}
	return EOF;
}
