/**
 * 
 * pttdial
 *
 * Copyright 2002 Paul T.Threshold
 *
 * hangup functions
 * 
 * This software is the proprietary information of Tresoldi Paolo.
 * Thou art not alloweth to remove the Copyright notice.
 *
 */
/**
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */


// hangup a connection
void hangup(HRASCONN hrasconn)
{
	cout << "Closing connection..." << std::endl;
	HINSTANCE hLib = LoadLibrary(RasFileName);
	RasHangUpType _RasHangUp= 
		(RasHangUpType)GetProcAddress(hLib,RasHangUpName);
	(*_RasHangUp)(hrasconn);
	cout << "Waiting for line to drop..." << std::endl;
	Sleep(4000);

	while (IsRasConnected() == "Connected") {
		cout << ".";
		Sleep(1000);
	}
	FreeLibrary(hLib);
	return;
}


// TODO hangup by Entry Name...
void hangup_entry(char * strEntryName)
{
/*	DWORD dwSizeBuf = 0;
	DWORD dwConnections = 0;
	
	RASCONN rasconn;
	rasconn.dwSize = sizeof(rasconn);
	
	DWORD dw = RasEnumConnections(&rasconn, &dwSizeBuf, &dwConnections);

	if(dwConnections <= 0) {
		cout << "Nothing to hang... :-(" << std::endl;
		return;
	}

	RASCONN *lpRasConn = new RASCONN[dwConnections];
	lpRasConn->dwSize = sizeof(*lpRasConn);

	RasEnumConnections(lpRasConn, &dwSizeBuf, &dwConnections);
	
	for(DWORD i = 0; i < dwConnections; i++) {
		strEntry = lpRasConn[i].szEntryName;
		if(strEntry.CompareNoCase(strEntryName) == 0) {
			hrasConn = lpRasConn[i].hrasconn;
		}
	}
	// ...
	delete []lpRasConn;
*/
}


// hangup all connections alive
void hangup_all()
{
	cout << "Shutting down all RAS connections..." << std::endl;
	HINSTANCE hLib = LoadLibrary(RasFileName);
	RasEnumConnectionsType _RasEnumConnections= 
		(RasEnumConnectionsType)GetProcAddress(hLib,RasEnumConnectionsName);

	DWORD dwSizeBuf = 0;
	DWORD dwConnections = 0;
	
	RASCONN rasconn;
	rasconn.dwSize = sizeof(rasconn);
	
	DWORD dw = (*_RasEnumConnections)(&rasconn, &dwSizeBuf, &dwConnections);

	if (dwConnections <= 0) {
		cout << "Nothing to hang... :-(" << std::endl;
		return;
	}

	RASCONN *lpRasConn = new RASCONN[dwConnections];
	lpRasConn->dwSize = sizeof(*lpRasConn);

	
	(*_RasEnumConnections)(lpRasConn, &dwSizeBuf, &dwConnections);
	
	for (DWORD i = 0; i < dwConnections; i++)
		hangup(lpRasConn[i].hrasconn);
	
	delete []lpRasConn;
	FreeLibrary(hLib);
}
