/**
 * 
 * pttdial 0.4 02/08/23
 *
 * Copyright 2002 Paul T.Threshold
 *
 * a utility to dial a RAS entry from the cmdline
 * 
 * This software is the proprietary information of Tresoldi Paolo.
 * Thou art not alloweth to remove the Copyright notice.
 *
 */
/**
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

// TODO try compilation with linkin to rasapi32.lib...

// (includes' order is relevant here)
#include "stdafx.h"
#include "pttdial.h"
#include "rasstatus.h"
#include "hangup.h"
#include "getopt.h"


void print_usage()
{
	cout << "Usage:" << std::endl <<
		"    pttdial -h : this help message                " << std::endl <<
		"            -s : display status                   " << std::endl <<
		"            -g : hangup after completion          " << std::endl <<
		"            -k : kill active connections          " << std::endl <<
		"            -V : display version infos and exit   " << std::endl <<
		std::endl <<
		"      the followin' are for dialin':              " << std::endl <<
		"            -e <remote access entry> (mandatory!!)" << std::endl <<
		"            -n <phone number>                     " << std::endl <<
		"            -u <user name>                        " << std::endl <<
		"            -p <password>                         " << std::endl <<
		"            -d <domain>                           " << std::endl <<
		"            -b <callback number>                  " << std::endl <<
#if (WINVER >= 0x401)
		"            -B <callback ID>                      " << std::endl <<
#endif
		"            -c <exec command>                     " << std::endl <<
		std::endl <<
		"NOTICE: the exec command must be the last parameter!!" << std::endl <<
		std::endl;
}



HRASCONN dial(	std::string entry,
		std::string phone,
		std::string user,
		std::string pass,
		std::string domain,
		std::string cbphone,
		std::string cbid)
{

	if (entry == "" && phone == "") {
		cout << std::endl <<
			"FATAL ERROR: missing Ras Entry name or Phone Number!! (-e | -n)" << std::endl << std::endl;
		print_usage();
		exit(1);
	}

	cout << std::endl << "Trying connection to '" << entry << "'..." << std::endl;

	// Try to load the library or die...
	HINSTANCE hLib = LoadLibrary(RasFileName);
	if (hLib == NULL) {
		cout << "FATAL ERROR: Loading of " << RasFileName << " failed!!" << std::endl;
		exit(1);
	}

	// Get functions address
	RasDialType _RasDial = 
		(RasDialType)GetProcAddress(hLib,RasDialName);
	RasErrorType _RasError= 
		(RasErrorType)GetProcAddress(hLib,RasError);
	
	BOOL bResult = FALSE;
	HRASCONN hrasconn;
	if (_RasDial) {
		cout << "Opening..." << std::endl;
		
		RASDIALPARAMS dialparms;

		::ZeroMemory(&dialparms, sizeof(dialparms));
		dialparms.dwSize = sizeof(dialparms);
		strcpy(dialparms.szEntryName,	entry.c_str());
		strcpy(dialparms.szPhoneNumber,	phone.c_str());
		strcpy(dialparms.szCallbackNumber, cbphone.c_str());
		strcpy(dialparms.szUserName,	user.c_str());
		strcpy(dialparms.szPassword,	pass.c_str());
		strcpy(dialparms.szDomain,	domain.c_str());
#if (WINVER >= 0x401)
		strcpy(dialparms.dwSubEntry,	"");
		strcpy(dialparms.dwCallbackId,	cbid.c_str());
#endif

		RASDIALEXTENSIONS dialexts;

		dialexts.dwSize = sizeof(dialexts);

/* dwfOptions:
#define RDEOPT_UsePrefixSuffix           0x00000001
#define RDEOPT_PausedStates              0x00000002 v
#define RDEOPT_IgnoreModemSpeaker        0x00000004 v
#define RDEOPT_SetModemSpeaker           0x00000008 v
#define RDEOPT_IgnoreSoftwareCompression 0x00000010
#define RDEOPT_SetSoftwareCompression    0x00000020 v
#define RDEOPT_DisableConnectedUI        0x00000040
#define RDEOPT_DisableReconnectUI        0x00000080
#define RDEOPT_DisableReconnect          0x00000100
#define RDEOPT_NoUser                    0x00000200
#define RDEOPT_PauseOnScript             0x00000400
#define RDEOPT_Router                    0x00000800 v
*/

		dialexts.dwfOptions =    0x0000082E;
		dialexts.hwndParent =    NULL;

		bResult = (*_RasDial)(&dialexts, NULL, &dialparms, 1, NULL, &hrasconn);

		if (bResult != 0) {
			char buffer[256];
			(*_RasError)(bResult, buffer, 256);
			cout << std::endl <<
				"FATAL ERROR: " << buffer << std::endl << std::endl;
			// hang up
			hangup(hrasconn);
			exit(1);
		}
	}
	
	// Don't forget to unload the library from memory
	FreeLibrary(hLib);

	return hrasconn;
}



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	// ras api
	std::string	entry,
			phone,
			user,
			pass,
			domain,
			cbphone,
			cbid,
			cmd_str;

	bool	Hangup = FALSE;

	cout << std::endl <<
		"pttdial v" << PTTDIAL_VERSION << " (c)2002 Paul T.Threshold" << std::endl <<
		std::endl;
	
	
	// get opts
	char optchr;
	//optargs = lpCmdLine;
	while ((optchr = getopt(lpCmdLine, "h?sgkVe:n:u:p:d:b:B:c:")) != EOF) {
		switch(optchr) {
			case 'h':
			case '?':
				print_usage();
				exit(0);
				break;
			case 's':
				cout << "Connection Status: " << IsRasConnected() << std::endl;
				exit(0);
				break;
			case 'k':
				hangup_all();
				exit(0);
				break;
			case 'V':
				cout << "  Version: '" << PTTDIAL_VERSION << "'" << std::endl;
				exit(0);
				break;
			case 'e':
				entry = optarg;
				cout << "RAS Entry: '" << entry << "'" << std::endl;
				break;
			case 'n':
				phone = optarg;
				cout << "Phone    : '" << phone << "'" << std::endl;
				break;
			case 'u':
				user = optarg;
				cout << "User     : '" << user << "'" << std::endl;
				break;
			case 'p':
				pass = optarg;
				//cout << "p: '" << pass << "'" << std::endl;
				cout << "p: '************'" << std::endl;
				break;
			case 'b':
				cbphone = optarg;
				cout << "Callback Number: '" << cbphone << "'" << std::endl;
				break;
#if (WINVER >= 0x401)
			case 'B':
				cbid = optarg;
				cout << "Callback ID    : '" << cbid << "'" << std::endl;
				break;
#endif
			case 'd':
				domain = optarg;
				cout << "Domain   : '" << domain << "'" << std::endl;
				break;
			case 'g':
				Hangup = TRUE;
				cout << "Enabled Hangup at program exit..." << std::endl;
				break;
			case 'c':
				cmd_str = optarg;
				cout << "Command to be Executed: '" << cmd_str << std::endl;
				break;
			default:
				opt_not_found(optchr);
				break;
		}
		
	}


	// try the connection and get the resultant hrasconn
	HRASCONN hrasconn = dial(entry, phone, user, pass, domain, cbphone, cbid);

	// show status
	cout << "Connection Status: " << IsRasConnected() << std::endl;
	
	// exec a commmand if there's one
	if (cmd_str != "" && hrasconn !=  NULL)
		system(cmd_str.c_str());
	
	// if Hangup, close connection before exitin'...
	if (Hangup)
		hangup(hrasconn);

	exit(0);
}
