////   RAS Connect status function
////
////   Written by Gilad Novik
////   For any questions or comments, gilad@bmidas.com


#ifndef _RASSTATUS
#define _RASSTATUS
#include <ras.h>


// We need to declare the functions type
typedef DWORD (WINAPI *RasEnumConnectionsType)(LPRASCONN lprasconn,LPDWORD lpcb,LPDWORD lpcConnections);
typedef DWORD (WINAPI *RasGetConnectStatusType)(HRASCONN hrasconn,LPRASCONNSTATUS lprasconnstatus);

#ifdef _UNICODE
#define RasFileName L"RASAPI32.DLL"
#define RasEnumConnectionsName L"RasEnumConnectionsW"
#define RasGetConnectStatusName L"RasGetConnectStatusW"
#else
#define RasFileName "RASAPI32.DLL"
#define RasEnumConnectionsName "RasEnumConnectionsA"
#define RasGetConnectStatusName "RasGetConnectStatusA"
#endif

std::string IsRasConnected()
{
	HINSTANCE hLib = LoadLibrary(RasFileName);	// Try to load the library
	if (hLib == NULL)
		return "error";	// Return FALSE if we can't find it

	// Get functions address
	RasEnumConnectionsType _RasEnumConnections = 
		(RasEnumConnectionsType)GetProcAddress(hLib,RasEnumConnectionsName);
	RasGetConnectStatusType _RasGetConnectStatus = 
		(RasGetConnectStatusType)GetProcAddress(hLib,RasGetConnectStatusName);
	BOOL bResult = FALSE;
	if (_RasEnumConnections && _RasGetConnectStatus)	// Check if it is valid pointer
	{
		RASCONN RasConn;
		RASCONNSTATUS RasConnStatus;
		RasConnStatus.dwSize = sizeof(RASCONNSTATUS);	// We need to set the size of the structure
		DWORD dwConnSize = sizeof(RASCONN);
		DWORD dwRasCount = 1;	// We only retrieve one connection
		RasConn.dwSize = dwConnSize;	// We need to set the size of the structure
		bResult =	// Let's check it out !!!
			(((*_RasEnumConnections)(&RasConn,&dwConnSize,&dwRasCount)) == 0)
			&& (((*_RasGetConnectStatus)(RasConn.hrasconn,&RasConnStatus)) == 0) 
			&& (RasConnStatus.rasconnstate == RASCS_Connected);
	}
	FreeLibrary(hLib);	// Don't forget to unload the library from memory
	if (bResult)
		return "Connected";
	else
		return "Offline";
}
#endif // _RASSTATUS
